/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.eldritch_mobs.ability.data;

import com.mojang.brigadier.ParseResults;
import java.util.Objects;
import net.hyper_pigeon.eldritch_mobs.ability.Ability;
import net.hyper_pigeon.eldritch_mobs.ability.AbilitySubType;
import net.hyper_pigeon.eldritch_mobs.ability.AbilityType;
import net.hyper_pigeon.eldritch_mobs.ability.ActivationType;
import net.minecraft.class_1282;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.server.MinecraftServer;

public class CustomAbility
implements Ability {
    String name;
    AbilityType abilityType;
    AbilitySubType abilitySubType;
    ActivationType activationType;
    String command;
    private long cooldown;
    private long nextUseTime = 0L;

    public CustomAbility(String name, AbilityType abilityType, AbilitySubType abilitySubType, ActivationType activationType, String command) {
        this.name = name;
        this.abilityType = abilityType;
        this.abilitySubType = abilitySubType;
        this.activationType = activationType;
        this.command = command;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AbilityType getAbilityType() {
        return this.abilityType;
    }

    @Override
    public AbilitySubType getAbilitySubType() {
        return this.abilitySubType;
    }

    @Override
    public boolean canUseAbility(class_1308 mobEntity) {
        return mobEntity.method_5770().method_8510() > this.nextUseTime && mobEntity.method_5968() != null;
    }

    @Override
    public long getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(long cooldown) {
        this.cooldown = cooldown;
    }

    @Override
    public void onAbilityUse(class_1308 mobEntity) {
        if (this.activationType == ActivationType.hasTarget && this.canUseAbility(mobEntity)) {
            String parsedCommand = this.command.replaceAll("\\{target\\}", mobEntity.method_5968().method_5845());
            parsedCommand = parsedCommand.replaceAll("\\{self\\}", mobEntity.method_5845());
            class_2168 commandSource = mobEntity.method_5682().method_3739();
            ParseResults parseResults = mobEntity.method_5682().method_3734().method_9235().parse(parsedCommand, (Object)commandSource);
            mobEntity.method_5682().method_3734().method_9249(parseResults, parsedCommand);
            this.nextUseTime = mobEntity.method_5770().method_8510() + this.getCooldown();
        }
    }

    @Override
    public void onDamaged(class_1309 entity, class_1282 source, float amount) {
        if (this.activationType == ActivationType.onDamage) {
            String parsedCommand = this.command.replaceAll("\\{self\\}", entity.method_5845());
            MinecraftServer minecraftServer = entity.method_5682();
            class_2168 commandSource = minecraftServer.method_3739();
            class_2170 commandManager = minecraftServer.method_3734();
            if (source.method_5529() != null && source.method_5529() instanceof class_1309) {
                parsedCommand = parsedCommand.replaceAll("\\{attacker\\}", source.method_5529().method_5845());
            }
            ParseResults parseResults = commandManager.method_9235().parse(parsedCommand, (Object)commandSource);
            Objects.requireNonNull(entity.method_5682()).method_3734().method_9249(parseResults, parsedCommand);
        }
    }

    @Override
    public void onDamageToTarget(class_1309 attacker, class_1309 target, class_1282 source, float amount) {
        if (this.activationType == ActivationType.onDamageToTarget) {
            String parsedCommand = this.command.replaceAll("\\{self\\}", attacker.method_5845());
            parsedCommand = parsedCommand.replaceAll("\\{target\\}", target.method_5845());
            MinecraftServer minecraftServer = attacker.method_5682();
            class_2168 commandSource = minecraftServer.method_3739();
            class_2170 commandManager = minecraftServer.method_3734();
            ParseResults parseResults = commandManager.method_9235().parse(parsedCommand, (Object)commandSource);
            Objects.requireNonNull(attacker.method_5682()).method_3734().method_9249(parseResults, parsedCommand);
        }
    }

    @Override
    public void onAttack(class_1309 attacker, class_1309 target) {
        if (this.activationType == ActivationType.onAttack) {
            String parsedCommand = this.command.replaceAll("\\{target\\}", target.method_5845());
            parsedCommand = parsedCommand.replaceAll("\\{self\\}", attacker.method_5845());
            MinecraftServer minecraftServer = target.method_5682();
            class_2168 commandSource = minecraftServer.method_3739();
            class_2170 commandManager = minecraftServer.method_3734();
            ParseResults parseResults = commandManager.method_9235().parse(parsedCommand, (Object)commandSource);
            Objects.requireNonNull(target.method_5682()).method_3734().method_9249(parseResults, parsedCommand);
        }
    }

    @Override
    public void onDeath(class_1309 livingEntity, class_1282 damageSource) {
        if (this.activationType == ActivationType.onDeath) {
            String parsedCommand = this.command.replaceAll("\\{self\\}", livingEntity.method_5845());
            if (damageSource.method_5529() != null) {
                parsedCommand = parsedCommand.replaceAll("\\{killer\\}", damageSource.method_5529().method_5845());
            }
            MinecraftServer minecraftServer = livingEntity.method_5682();
            class_2168 commandSource = minecraftServer.method_3739();
            class_2170 commandManager = minecraftServer.method_3734();
            ParseResults parseResults = commandManager.method_9235().parse(parsedCommand, (Object)commandSource);
            Objects.requireNonNull(livingEntity.method_5682()).method_3734().method_9249(parseResults, parsedCommand);
        }
    }

    @Override
    public void passiveApply(class_1308 mobEntity) {
        if (this.activationType == ActivationType.tick) {
            String parsedCommand = this.command.replaceAll("\\{self\\}", mobEntity.method_5845());
            MinecraftServer minecraftServer = mobEntity.method_5682();
            class_2168 commandSource = minecraftServer.method_3739();
            class_2170 commandManager = minecraftServer.method_3734();
            ParseResults parseResults = commandManager.method_9235().parse(parsedCommand, (Object)commandSource);
            Objects.requireNonNull(mobEntity.method_5682()).method_3734().method_9249(parseResults, parsedCommand);
        }
    }
}

